/*** 1.   ũƮ ***/

CREATE TABLE TB_SPLIT (Seq BIGINT, Code VARCHAR(100))

INSERT INTO TB_SPLIT
SELECT rownum, NEWID()
FROM (
	SELECT ROW_NUMBER() OVER (ORDER BY A.number) AS rownum, A.number
	FROM master..spt_values A 
	JOIN master..spt_values B 
	ON A.type = 'P' AND B.type = 'P' AND A.number <= 1000 AND B.number <= 100
) A

CREATE INDEX NIDX01_SPLIT ON TB_SPLIT(Code)
GO

/*** Լ  ***/
CREATE FUNCTION [dbo].FN_SPLIT (
	@strList VARCHAR(MAX),
	@strDelimiter VARCHAR(10))
RETURNS @Array TABLE (Value varchar(4000))

BEGIN
IF @strList IS NULL RETURN

DECLARE @strLen int = LEN(@strList)
DECLARE @byLenDelimiter TINYINT

SET @byLenDelimiter = LEN(@strDelimiter)
SET @strList = @strList + @strDelimiter;

WITH WT_TRECT (RN, CUT, REMAIN) AS (
	SELECT 1 RN
	     , SUBSTRING(@strList, 1, ABS(CHARINDEX (@strDelimiter, @strList) - 1)) AS CUT
	     , SUBSTRING(@strList, LEN(SUBSTRING(@strList,1
	     , ABS(CHARINDEX(@strDelimiter, @strList)-1)))+1+@byLenDelimiter, @strLen
	     ) AS REMAIN
	UNION ALL
	SELECT RN + 1 AS RN
	     , SUBSTRING(REMAIN, 1, ABS(CHARINDEX(@strDelimiter, REMAIN) - 1)) AS CUT
	     , SUBSTRING(REMAIN, LEN(SUBSTRING(REMAIN, 1, ABS(CHARINDEX(@strDelimiter, 
	       REMAIN)-1)))+1+ @byLenDelimiter, @strLen) AS REMAIN
	FROM WT_TRECT 
	WHERE CUT <> @strDelimiter AND LEN(REMAIN) > 0
)
INSERT INTO @Array SELECT CUT FROM WT_TRECT WHERE LEN(CUT)>0 ORDER BY RN
OPTION (maxrecursion 0)
RETURN
END
GO


/*** 2. [AS-IS] SQL    ȹ ***/

SELECT Code, COUNT(*) AS Cnt
FROM TB_SPLIT A CROSS APPLY FN_SPLIT(A.Code, '-')
GROUP BY Code
GO


/*** 6. [TO-BE]   ***/

SELECT Code, COUNT(*) AS Cnt
FROM TB_SPLIT A CROSS APPLY STRING_SPLIT(A.Code, '-')
GROUP BY Code
GO